using System;
using gov.va.med.vbecs.DAL.HL7.OpenLibrary.Messages;

namespace gov.va.med.vbecs.DAL.HL7.OpenLibrary
{
	/// <summary>
	/// VBECS HL7 base exception. All HL7 exceptions must be derived from it.
	/// </summary>
	[Serializable]		//Added for defect# 286500 on 3/21/2016 By Russell Stephenson
    public class Hl7AckException : ApplicationException
	{
	    private readonly HL7ProtocolMessage _ack;

	    /// <summary>
	    /// This constructor allows adding inner exception that caused this exception.
	    /// </summary>
	    /// <param name="ack">ack message.</param>
	    /// <param name="message">message</param>
	    /// <param name="innerException">Inner exception that caused this exception.</param>
	    public Hl7AckException(HL7ProtocolMessage ack, string message, Exception innerException)
            : base(message, innerException)
	    {
	        _ack = ack;
	    }

	    /// <summary>
        /// ack message.
	    /// </summary>
	    public HL7ProtocolMessage Ack
	    {
	        get { return _ack; }
	    }
	}
}
